@extends('user.user_master')
@section('user.user_content')
@section('user_title')
News & Notice - Lists
@endsection
@php
$images = \App\Models\Theme::find(1);
@endphp
<section class="mb-4">
        <!-- Page Content -->
        <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
            <div class="container page-opacity">
                <div class="row">
                    <div class="col-md-12">
                        <h1> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('News and Notice Lists', 'ne') }} @else News and Notice Lists @endif</h1>
                        <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Education is an ornament in prosperity and a refuge in adversity.', 'ne') }} @else Education is an ornament in prosperity and a refuge in adversity. @endif</span>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Projects Start -->
    <section>
        <div class="container-xxl mb-5 mt-5">
            <div class="container">


                <div class="row portfolio-container">

                    <div class="row mt-4 mt-md-5 pxp-animate-in pxp-animate-in-top">
                        @foreach($news as $new)
                        <div class="col-md-6 col-xl-4 col-xxl-3 pxp-jobs-card-1-container mb-4">
                            <div class="pxp-jobs-card-1 border p-2 rounded">
                                <div class="pxp-jobs-card-1-top mb-4">
                                    <div class="pxp-jobs-card-1-details">
                                        <a href="{{url('/news-notice-details',$new->id.'/'.$new->notice_title)}}">
                                          @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans(\Illuminate\Support\Str::limit($new->notice_title, 55), 'ne') }} @else {{\Illuminate\Support\Str::limit($new->notice_title, 55)}} @endif
                                        </a>
                                    </div>
                                </div>
                                <div class="pxp-jobs-card-1-bottom">
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="pxp-jobs-card-1-bottom-left">
                                                <a href="single-company-1.html"
                                                    class="text-white btn btn-danger btn-sm">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($new->notice_type, 'ne') }} @else {{$new->notice_type}}  @endif</a>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-6 text-end">
                                            <p class="pxp-jobs-card-1-date pxp-text-light">@php
                                            $year = $new->created_at->format('Y');
                                            $month = $new->created_at->format('m');
                                            $day = $new->created_at->format('d');
                                            $date = Bsdate::eng_to_nep($year, $month, $day);
                                            echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year']
                                            @endphp</p>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        @endforeach
                        
                    </div>




                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <nav aria-label="Page navigation example" class="mt-5 mb-5">
                        <ul class="pagination justify-content-center" style="font-family: 'Titillium Web', sans-serif;">
                            <div style="box-shadow: 0px 4px 4px 4px rgb(231, 230, 230);display: flex;">
                                {{$news->links()}}
                            </div>

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </section>
    <!-- Projects End -->

    @endsection

