@extends('admin.admin_master')
@section('admin.admin_content')
<script src="https://unpkg.com/dropzone@5/dist/min/dropzone.min.js"></script>
<link rel="stylesheet" href="https://unpkg.com/dropzone@5/dist/min/dropzone.min.css" type="text/css" />
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Edit Staff & Faculties</h4>
    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">Edit Staff & Faculties</h5>
                    </div>
               
                </div>
                <!-- Account -->
                <hr class="my-0" />
                <div class="card-body">
                    <form id="formAccountSettings dropzone" method="POST" action="{{ route('admin.facultiesstaff_store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <h5 class="fw-bold py-3 mb-3">Staff Information</h5>
                            <div class="mb-3 col-md-12">
                                <label for="title" class="form-label">Page Title <span class="text-danger">*</span></label>
                                <input class="form-control title_count" type="text" id="title" placeholder="Staff and Faculates" name="title" value="{{$staff->title}}" />
                                @error('title')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                                <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="des" class="form-label">Details <span class="text-danger">*</span></label>
                                <textarea class="form-control ckeditor" id="des" name="des" cols="10" rows="10">{{$staff->des}}</textarea>
                                @error('des')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="mt-2 float-end">
                            <button type="submit" class="btn btn-primary me-2">Update Records</button>
                            <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                        </div>
                </div>
                </form>
            </div>
            <!-- /Account -->
        </div>
    </div>
</div>

<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script>
    $(document).ready(function() {
        $('#multiImg').on('change', function() { //on file input change
            if (window.File && window.FileReader && window.FileList && window.Blob) //check File API supported browser
            {
                var data = $(this)[0].files; //this file data

                $.each(data, function(index, file) { //loop though each file
                    if (/(\.|\/)(gif|jpe?g|png)$/i.test(file.type)) { //check supported file type
                        var fRead = new FileReader(); //new filereader
                        fRead.onload = (function(file) { //trigger function on successful read
                            return function(e) {
                                var img = $('<img/>').addClass('thumb').attr('src', e.target.result).width(80)
                                    .height(80); //create image element 
                                $('#preview_img').append(img); //append image to output element
                            };
                        })(file);
                        fRead.readAsDataURL(file); //URL representing the file's data.
                    }
                });

            } else {
                alert("Your browser doesn't support File API!"); //if File API is absent
            }
        });
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.ckeditor').ckeditor();
    });
</script>

@endsection