@extends('admin.admin_master')
@section('admin.admin_content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- ✅ load jQuery ✅ -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


<!-- ✅ load DataTables ✅ -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js" integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- Content -->
<section>

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Information</h4>

        @php
        $i = 1;
        @endphp
        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">List Courses</h5>

                </div>

            </div>


            <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                <table class="table" id="exampleTable" width="100%">
                    <thead>
                        <tr class="text-nowrap">
                            <th>SN</th>
                            <th>Title</th>
                            <th>Icon</th>
                            <th>Count Number</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        @foreach($info as $key=> $inf)
                        <tr>
                            <td>{{$key+1;}}</td>
                            <td>{{ $inf->title }}</td>
                            <td><img src="{{ asset($inf->logo) }}" height="40px" alt=""></td>
                            <td>{{ $inf->count }}</td>
                            <td>
                            @php
                                $user_auth = \Illuminate\Support\Facades\Auth::user();
                                @endphp
                                @if($user_auth->admin_type == "Author User")    
                            <a data-bs-toggle="modal" data-bs-target="#basicModal{{ $inf->id }}" class="btn btn-primary text-white">Edit</a>
                        @else
                        <span class="text-danger">Action connot access</span>
                        @endif
                        </td>

                        </tr>
                        <div class="modal fade" id="basicModal{{ $inf->id }}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel1">Edit Information</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('admin.information_update_store', $inf->id) }}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col mb-3">
                                                    <label for="nameBasic" class="form-label">Title<span class="text-danger">*</span></label>
                                                    <input type="text" id="title" class="form-control title_count" value="{{ $inf->title }}" name="title" placeholder="Diploma in IT" />
                                                    @error('title')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                    <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>

                                                </div>
                                            </div>
                                            <div class="row g-2">
                                                <div class="col mb-3">
                                                    <label for="emailBasic" class="form-label">Count Number<span class="text-danger">*</span>
                                                    </label>
                                                    <input type="text" id="count" class="form-control" name="count" value="{{ $inf->count }}" placeholder="3" />
                                                    @error('count')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>

                                            </div>
                                            <div class="mb-3 col-md-12">
                                                <label for="image" class="form-label">Icon <span class="text-danger">*</span></label>
                                                <input type="file" class="form-control" id="logo" name="logo" onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                                @error('image')
                                                <p class="text-danger">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <img src="{{ asset($inf->logo) }}" width="80px" alt="" id="adminProImg">
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                                Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Update</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Basic Bootstrap Table -->
    </div>
    <!-- / Content -->

</section>
<script>
    $(document).ready(function() {
        $.noConflict();
        $('#exampleTable').DataTable();
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        function mainProImgUrl(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#adminProImg').attr('src', e.target.result).width(80).height(80);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection