@extends('admin.admin_master')
@section('admin.admin_content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Create New Download</h4>

        <div class="row">
            <div class="col-md-12">

                <div class="card mb-4">
                    <div class="row">
                        <div class="col-6 col">
                            <h5 class="card-header">Add Download</h5>

                        </div>
                        <div class="col-6 col card-header">
                            <a href="{{ route('admin.download_all_view') }}"
                                class="float-end btn btn-primary text-nowrap add-new-role">View All Download</a>
                        </div>
                    </div>
                    <!-- Account -->
                    <hr class="my-0" />
                    <div class="card-body">
                        <form id="formAccountSettings" method="POST" action="{{ route('admin.download_all_store') }}"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <h5 class="fw-bold py-3 mb-3">Download Information</h5>
                                <div class="mb-3 col-md-12">
                                    <label for="title" class="form-label">Download Title <span
                                            class="text-danger">*</span></label>
                                            <input type="text" name="title" id="title" placeholder="Notice Title" class="form-control title_count">
                                    @error('title')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                    <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>

                                </div>
                            </div> 
                            <h5 class="fw-bold py-3 mb-3">Upload PDF File </h5>
                            <div class="mb-3 col-md-6">
                                <label for="file" class="form-label">PDF <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" id="file" name="file[]" multiple=""
                                    onchange="mainProImgUrl(this)"/>
                                @error('file')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="mt-2 float-end">
                                <button type="submit" class="btn btn-primary me-2">Add Download</button>
                                <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                            </div>
                    </div>

                    </form>
                </div>
                <!-- /Account -->
            </div>
        </div>
    </div>
    </div>
    <!-- / Content -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    
     <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
     <script type="text/javascript">
         $(document).ready(function() {
             $('.ckeditor').ckeditor();
         });
     </script>
 
@endsection
