<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Slider;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Session;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\Theme;
use Brian2694\Toastr\Facades\Toastr;

class AdminThemeController extends Controller
{
    //Admin Theme Update
    public function AdminThemeUpdateView()
    {
        Session::put('admin_page', 'admin_theme_view');
        $theme_update = Theme::find(1);
        return view('admin.theme.theme_update', compact('theme_update'));
    }


    //Admin Theme Update Code
    public function AdminThemeUpdateStore(Request $request)
    {
        $request->validate([
            'phone'=>'required|max:255|regex:/^[a-zA-Z0-9\s]+$/',
            'email'=>'email|required|max:255',
            'telephone' => 'required|max:255|regex:/^[a-zA-Z0-9\s]+$/',
            'address'=>'required |max:255',
            'logo'=> 'nullable|image|max:1024',
            'logo_np'=> 'nullable|image|max:1024',
            'image'=> 'nullable|image|max:1500',
        ]);
        $theme_update = Theme::find(1);
        $theme_update->phone = $request->phone;
        $theme_update->email = $request->email;
        $theme_update->telephone = $request->telephone;
        $theme_update->address = $request->address;
        if ($request->file('logo')) {
            $file = $request->file('logo');
            @unlink($theme_update->logo);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/theme_logo/' . $filename);
            $uploadPath = './uploads/theme_logo/' . $filename;
            $theme_update->logo = $uploadPath;
        }
        if ($request->file('logo_np')) {
            $file = $request->file('logo_np');
            @unlink($theme_update->logo_np);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/nepali_logo/' . $filename);
            $uploadPath = './uploads/nepali_logo/' . $filename;
            $theme_update->logo_np = $uploadPath;
        }
        if ($request->file('image')) {
            $file = $request->file('image');
            @unlink($theme_update->image);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/theme_page_img/' . $filename);
            $uploadPath = './uploads/theme_page_img/' . $filename;
            $theme_update->image = $uploadPath;
        }
        $theme_update->save();
        Toastr::success('Theme Updated Successfully');
        return redirect()->back();
    }
}
