<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Gallery;
use App\Models\GalleryImage;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;

class AdminGalleryController extends Controller
{
    //Gallery View
    public function AdminGalleryView()
    {
        Session::put('admin_page', 'admin_gallery_view');
        $gallery = Gallery::latest()->get();
        return view('admin.gallery.gallery_view', compact('gallery'));
    }


    //Gallery Add View
    public function AdminGalleryAdd()
    {
        Session::put('admin_page', 'admin_gallery_view');
        return view('admin.gallery.gallery_add');
    }

    //Gallery Store 
    public function AdminGalleryStore(Request $request)
    {
        $request->validate([
            'title' => 'max:255|required',
            'image' => 'required',
        ]);

        $gallery_id = Gallery::insertGetId([
            'user_id' => Auth::id(),
            'title' => $request->title,
            'title_slug' => Str::slug($request->title),
            'created_at' => Carbon::now(),
        ]);
        $image = $request->file('image');
        foreach ($image as $img) {
            $make_name = hexdec(uniqid()) . '.' . $img->getClientOriginalExtension();
            Image::make($img)->save('./uploads/gallery_image/' . $make_name);
            $uploadPath = './uploads/gallery_image/' . $make_name;
            GalleryImage::insert([
                'gallery_id' => $gallery_id,
                'image' => $uploadPath,
                'created_at' => Carbon::now(),
            ]);
        }
        Toastr::success('Gallery Add Successfully');
        return redirect()->back();
    }

    //Gallery Image Details 
    public function AdminGalleryDetails($id)
    {
        Session::put('admin_page', 'admin_gallery_view');
        $gallery_details = GalleryImage::where('gallery_id', $id)->get();
        return view('admin.gallery.gallery_details', compact('gallery_details'));
    }


    //Gallery Image Delete
    public function AdminGalleryImageDelete($id)
    {
        $old_img = GalleryImage::find($id);
        @unlink($old_img->image);
        GalleryImage::find($id)->delete();
        Toastr::success('Image Deleted Successfully');
        return redirect()->back();
    }

    //Gallery Image Update
    public function AdminGalleryImageUpdate(Request $request)
    {
        $request->validate([
            'image'=>'required',
        ]);
        $image = $request->file('image');
        foreach ($image as $id => $img) {
            $imageDel = GalleryImage::find($id);
            @unlink($imageDel->image);
            $make_name = hexdec(uniqid()) . '.' . $img->getClientOriginalExtension();
            Image::make($img)->save('./uploads/gallery_image/' . $make_name);
            $uploadPath = './uploads/gallery_image/' . $make_name;
            GalleryImage::where('id', $id)->update([
                'image' => $uploadPath,
                'created_at' => Carbon::now(),
            ]);
        }
        Toastr::success('Image Updated Successfully');
        return redirect()->back();
    }


    //Gallery Delete
    public function AdminGalleryDelete($id)
    {
        Gallery::find($id)->delete();
        $gallery_image = GalleryImage::where('gallery_id', $id)->get();
        @unlink($gallery_image->image);
        $gallery_image->delete();
        Toastr::success('Image Deleted Successfully');
        return redirect()->back();
    }
}
