<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\QuickAccess;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;

class AdminFooterController extends Controller
{
    //Footer Quick Access Links View
    public function QuickAccessView()
    {
        Session::put('admin_page', 'admin_footer_view');
        $quickaccess = QuickAccess::latest()->get();
        return view('admin.footer.footer_quick_access', compact('quickaccess'));
    }


    //Footer Quick Access Link Store
    public function QuickAccessStore(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255',
            'link' => 'required|max:255',
            'logo' => 'required'
        ]);
        $quickaccess = new QuickAccess();
        $quickaccess->name = $request->name;
        $quickaccess->link = $request->link;
        if ($request->file('logo')) {
            $file = $request->file('logo');
            @unlink($quickaccess->logo);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/quick_access/' . $filename);
            $uploadPath = './uploads/quick_access/' . $filename;
            $quickaccess->logo = $uploadPath;
        }

        $quickaccess->save();
        Toastr::success('Items Added Successfully');
        return redirect()->back();
    }

    //Footer Quick Access Link Update
    public function QuickAccessUpdate(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:255',
            'link' => 'required|max:255',
            'logo' => 'nullable',
        ]);
        $quickaccess = QuickAccess::find($id);
        $quickaccess->name = $request->name;
        $quickaccess->link = $request->link;
        if ($request->file('logo')) {
            $file = $request->file('logo');
            @unlink($quickaccess->logo);
            $filename = date('YmsHi') . $file->getClientOriginalName();
            Image::make($file)->save('./uploads/quick_access/' . $filename);
            $uploadPath = './uploads/quick_access/' . $filename;
            $quickaccess->logo = $uploadPath;
        }
        $quickaccess->save();
        Toastr::success('Items Updated Successfully');
        return redirect()->back();
    }

    //Footer Quick Access Link Delete
    public function QuickAccessDelete($id)
    {
        $quickaccess_delete = QuickAccess::find($id);
        @unlink($quickaccess_delete->logo);
        $quickaccess_delete->delete();
        Toastr::success('Items Deleted Successfully');
        return redirect()->back();
    }
}
