<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admission;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Session;
use Brian2694\Toastr\Facades\Toastr;

class AdminAdmissionController extends Controller
{
    //Admission View
    public function AdminAdmissionView()
    {
        $admissions = Admission::latest()->get();
        return view('admin.admission.admission_view', compact('admissions'));
    }
     //Admission Add View
     public function AdminAdmissionAdd()
     {
         return view('admin.admission.admission_add');
     }

     //Admission Store View
     public function AdminAdmissionStore(Request $request)
     {
        $request->validate([
            'title' => 'max:255|required|unique:admissions,title',
            'para' => 'required',
        ]);
        $admission_store = new Admission();
        $admission_store->title = $request->title;
        $admission_store->title_slug = Str::slug($request->title);
        $admission_store->para = $request->para;
        $admission_store->save();
        Toastr::success('Admission Page Created Successfully');
        return redirect()->back();
     }
      //Admission Edit View
    public function AdminAdmissionEdit($id)
    {
        $admission_edit = Admission::find($id);
        return view('admin.admission.admission_edit', compact('admission_edit'));
    }

    //Admission Store View
    public function AdminAdmissionUpdate(Request $request, $id)
    {
       $request->validate([
           'title' => 'max:255|required',
           'para' => 'required',
       ]);
       $admission_store = Admission::find($id);
       $admission_store->title = $request->title;
       $admission_store->title_slug = Str::slug($request->title);
       $admission_store->para = $request->para;
       $admission_store->save();
       Toastr::success('Admission Page Updated Successfully');
       return redirect()->back();
    }

     //Admission Store View
     public function AdminAdmissionDelete($id)
     {
        $admission_delete = Admission::find($id);
        $admission_delete->delete();
        Toastr::success('Admission Page Deleted Successfully');
        return redirect()->back();
     }
}
